<?php
header("Content-Type: application/json");

// Database configuration
$host = "localhost";
$user = "ygfhkamb_rakib887766";
$pass = "Raakib887766@#";
$db   = "ygfhkamb_MatchData";

// Database connection
try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'DB connection failed: ' . $e->getMessage()]);
    exit;
}

$upload_dir = '../upload_proof/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}
if (!is_writable($upload_dir)) {
    echo json_encode(['status' => 'error', 'message' => 'Directory not writable']);
    exit;
}

// ✅ Read raw JSON input
$rawData = file_get_contents("php://input");
$data    = json_decode($rawData, true);

$match_id   = isset($data['match_id']) ? trim($data['match_id']) : '';
$user_phone = isset($data['user_phone']) ? trim($data['user_phone']) : '';
$screenshot = isset($data['screenshot']) ? trim($data['screenshot']) : '';

if (empty($match_id) || empty($user_phone) || empty($screenshot)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing match_id, user_phone or screenshot']);
    exit;
}

$filename = 'proof_' . $match_id . '_' . $user_phone . '_' . time() . '.jpg';
$filepath = $upload_dir . $filename;

$decoded = base64_decode($screenshot);
if ($decoded === false) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid base64 image']);
    exit;
}

file_put_contents($filepath, $decoded);

try {
    // ✅ match_id + user_phone দিয়ে update
    $stmt = $pdo->prepare("UPDATE user_match_joined 
                           SET proof = ?, has_proof = 1 
                           WHERE match_id = ? AND user_phone = ?");
    $stmt->execute([$filename, $match_id, $user_phone]);

    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'status'     => 'success',
            'message'    => 'Proof uploaded successfully',
            'proof_url'  => $filename
        ]);
    } else {
        unlink($filepath); // no record updated → delete file
        echo json_encode(['status' => 'error', 'message' => 'No record found for this match & user']);
    }
} catch (PDOException $e) {
    unlink($filepath);
    echo json_encode(['status' => 'error', 'message' => 'DB error: ' . $e->getMessage()]);
}
