<?php
header("Content-Type: application/json");

// ✅ Database connection
$host = "localhost";
$user = "ygfhkamb_rakib887766";
$pass = "Raakib887766@#";
$db   = "ygfhkamb_MatchData";

$conn = new mysqli($host, $user, $pass, $db);

// ✅ Check connection
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "DB connection failed: " . $conn->connect_error]);
    exit;
}

// ✅ Get match_id from URL
$match_id = $_GET['match_id'] ?? '';
if (!$match_id) {
    echo json_encode(["status" => "error", "message" => "match_id missing"]);
    exit;
}

// ✅ Prepare and execute query
$query = "SELECT name, rank, kills, winning, is_top FROM winners WHERE match_id = ? ORDER BY is_top DESC, rank ASC";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $match_id);
$stmt->execute();
$res = $stmt->get_result();

// ✅ Separate top winners and others
$top = [];
$others = [];
while ($row = $res->fetch_assoc()) {
    if ($row['is_top'] == 1) {
        $top[] = $row;
    } else {
        $others[] = $row;
    }
}

// ✅ Response
echo json_encode([
    "status" => "success",
    "top_winners" => $top,
    "other_winners" => $others
]);

$conn->close();
?>
