<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Database config
$servername = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$dbname = "ygfhkamb_MatchData";

// Connect
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit();
}

// Inputs
$mobile = $_POST['mobile'] ?? '';
$image = $_POST['image'] ?? '';

if (empty($mobile) || empty($image)) {
    echo json_encode(["success" => false, "message" => "Mobile or image missing"]);
    exit();
}

// Save folder
$folder = "profile_images/";
$targetDir = __DIR__ . "/" . $folder;
if (!file_exists($targetDir)) {
    mkdir($targetDir, 0777, true);
}

// Create image file
$imageName = "IMG_" . time() . "_" . rand(1000, 9999) . ".jpg";
$imagePath = $folder . $imageName;
$fullPath = $targetDir . $imageName;

$imageDecoded = base64_decode($image);
if (!$imageDecoded) {
    echo json_encode(["success" => false, "message" => "Base64 decode failed"]);
    exit();
}

if (file_put_contents($fullPath, $imageDecoded)) {
    $stmt = $conn->prepare("UPDATE users SET profileImage = ? WHERE mobile = ?");
    $stmt->bind_param("ss", $imagePath, $mobile);

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Image uploaded successfully",
            "image_path" => $imagePath
        ]);
    } else {
        echo json_encode(["success" => false, "message" => "Database update failed"]);
    }
    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Image saving failed"]);
}

$conn->close();
?>
