<?php
header('Content-Type: application/json');

// Database connection
$servername = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$dbname = "ygfhkamb_MatchData";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit();
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Sanitize input
$first_name     = isset($input['first_name']) ? $conn->real_escape_string($input['first_name']) : '';
$last_name      = isset($input['last_name']) ? $conn->real_escape_string($input['last_name']) : '';
$mobile         = isset($input['mobile']) ? $conn->real_escape_string($input['mobile']) : '';
$password_input = isset($input['password']) ? $conn->real_escape_string($input['password']) : '';
$total_played   = isset($input['total_played']) ? intval($input['total_played']) : 0;
$total_won      = isset($input['total_won']) ? intval($input['total_won']) : 0;
$total_tk       = isset($input['total_tk']) ? intval($input['total_tk']) : 0;
$profile_image  = isset($input['image']) ? $conn->real_escape_string($input['image']) : '';
$referred_by    = isset($input['referred_by']) ? trim($conn->real_escape_string($input['referred_by'])) : '';
$device_id      = isset($input['device_id']) ? $conn->real_escape_string($input['device_id']) : '';
$is_blocked     = 'Active';

// Validate required fields
if (empty($first_name) || empty($last_name) || empty($mobile) || empty($password_input) || empty($device_id)) {
    echo json_encode(["success" => false, "message" => "All fields are required"]);
    exit();
}

// Device ID check: একই ডিভাইস থেকে ২টির বেশি অ্যাকাউন্ট
$sql_device_check = "SELECT id FROM users WHERE device_id='$device_id'";
$result_device = $conn->query($sql_device_check);
if ($result_device->num_rows >= 2) {
    echo json_encode(["success" => false, "message" => "This device has reached the maximum number of accounts"]);
    exit();
}

// Check for existing user by mobile only (email removed)
$sql_check = "SELECT id FROM users WHERE mobile='$mobile'";
$result_check = $conn->query($sql_check);
if ($result_check->num_rows > 0) {
    echo json_encode(["success" => false, "message" => "User with this mobile already exists"]);
    exit();
}

// Function to generate referral code (prefix + random 4 digit)
function generateReferralCode($conn, $firstName) {
    $onlyLetters = preg_replace("/[^A-Za-z]/", '', $firstName);
    $prefix = strtoupper(substr($onlyLetters, 0, 3));
    if (empty($prefix)) {
        $prefix = 'USR';
    }
    do {
        $random = rand(1000, 9999);
        $code = $prefix . $random;
        $check = $conn->query("SELECT id FROM users WHERE referral_code='$code'");
    } while ($check->num_rows > 0);
    return $code;
}

// Generate referral code for new user
$referral_code = generateReferralCode($conn, $first_name);

// ---------- Refer Bonus Logic Start ----------
if (!empty($referred_by)) {
    $referrerQuery = $conn->query("SELECT mobile FROM users WHERE referral_code = '$referred_by'");
    
    if ($referrerQuery && $referrerQuery->num_rows > 0) {
        $referrer = $referrerQuery->fetch_assoc();
        $referrerPhone = $referrer['mobile'];

        // Bonus from settings
        $receiverBonus = 0;
        $referrerBonus = 0;

        $bonusResult1 = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'refer_bonus_receiver'");
        if ($bonusResult1 && $bonusResult1->num_rows > 0) {
            $receiverBonus = intval($bonusResult1->fetch_assoc()['setting_value']);
        }

        $bonusResult2 = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'refer_bonus_referrer'");
        if ($bonusResult2 && $bonusResult2->num_rows > 0) {
            $referrerBonus = intval($bonusResult2->fetch_assoc()['setting_value']);
        }

        // Add bonus to new user
        $total_tk += $receiverBonus;

        // Add bonus to referrer user
        $conn->query("UPDATE users SET user_tk = user_tk + $referrerBonus WHERE mobile = '$referrerPhone'");
    }
}
// ---------- Refer Bonus Logic End ----------

// Insert new user (email এবং fcm_token বাদ)
$sql_insert = "INSERT INTO users 
    (first_name, last_name, mobile, password, totalPlayed, totalWon, user_tk, is_blocked, profileImage, referral_code, referred_by, device_id)
    VALUES
    ('$first_name', '$last_name', '$mobile', '$password_input', $total_played, $total_won, $total_tk, '$is_blocked', '$profile_image', '$referral_code', '$referred_by', '$device_id')";

if ($conn->query($sql_insert) === TRUE) {
    echo json_encode([
        "success" => true,
        "message" => "Registration successful",
        "referral_code" => $referral_code
    ]);
} else {
    echo json_encode(["success" => false, "message" => "Error: " . $conn->error]);
}

$conn->close();
?>
