<?php
header('Content-Type: application/json');

$con = new mysqli("localhost", "ygfhkamb_rakib887766", "Raakib887766@#", "ygfhkamb_MatchData");
if ($con->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $con->connect_error]));
}

$phone   = $_POST['phone']   ?? '';
$status  = $_POST['status']  ?? '';
$title   = $_POST['title']   ?? '';
$message = $_POST['message'] ?? '';

if (empty($phone) || empty($status) || empty($title) || empty($message)) {
    echo json_encode(["error" => "All fields are required."]);
    exit;
}

// ফোন নম্বর ফরম্যাট করা (শুধু নাম্বার রাখা, কিন্তু 0 সহ)
$phone = preg_replace('/[^0-9]/', '', $phone);

// ✅ ইউজারের স্ট্যাটাস আপডেট
$stmt = $con->prepare("UPDATE users SET is_blocked = ? WHERE mobile = ?");
$stmt->bind_param("ss", $status, $phone);
if (!$stmt->execute()) {
    echo json_encode(["error" => "Failed to update status: " . $stmt->error]);
    exit;
}
$stmt->close();

// ✅ ইমেজ URL নির্ধারণ
$imageUrl = getStatusImageUrl($status);

// ✅ OneSignal এ External User ID (phone) টার্গেট করে নোটিফিকেশন পাঠানো
$notifyResponse = sendNotificationToExternalUser($title, $message, $phone, $imageUrl);

// OneSignal রেস্পন্স পার্স করে চেক করা
$responseData = json_decode($notifyResponse, true);

if (isset($responseData['errors'])) {
    echo json_encode([
        "status" => "error",
        "message" => "OneSignal Error",
        "details" => $responseData['errors']
    ]);
} else if (isset($responseData['id'])) {
    echo json_encode([
        "status" => "success",
        "message" => "Notification sent successfully",
        "notification_id" => $responseData['id']
    ]);
} else {
    echo json_encode([
        "status" => "warning",
        "message" => "Unknown response from OneSignal",
        "response" => $responseData
    ]);
}

$con->close();

// -------- Functions -----------

function getStatusImageUrl($status) {
    switch ($status) {
        case "Warning 1":
        case "Warning 2":
            return "https://www.skill-zone.xyz/images/warning.jpg";
        case "Block":
            return "https://www.skill-zone.xyz/images/block.jpg";
        case "Active":
            return "https://www.skill-zone.xyz/images/active.jpg";
        default:
            return "https://www.skill-zone.xyz/images/default.png";
    }
}

function sendNotificationToExternalUser($heading, $message, $externalUserId, $imageUrl) {
    // OneSignal এ External ID হিসেবে ঠিক 01887759336 এই ফরম্যাটে আছে
    // তাই শুধু নন-নিউমেরিক ক্যারেক্টার রিমুভ করব কিন্তু 0 সহ রাখব
    $externalUserId = preg_replace('/[^0-9]/', '', $externalUserId);
    
    $content = ["en" => $message];

    $fields = [
        'app_id' => "f4f3f72a-7a80-4a4d-bfc2-29ba2a4c79e9",
        'include_external_user_ids' => [$externalUserId], // include_aliases এর বদলে এটি ব্যবহার করুন
        'target_channel' => 'push',
        'data' => ["type" => "user_status"],
        'headings' => ["en" => $heading],
        'contents' => $content,
        'large_icon' => $imageUrl,
        'big_picture' => $imageUrl,
        'ios_attachments' => ['id' => $imageUrl]
    ];

    $fields = json_encode($fields);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic os_v2_app_6tz7okt2qbfe3p6cfg5cutdz5eh43f7upbiey6vwoywm535edrmsppzxidizy3vktnwmlf7l2dxm5hfpubhynhxj2tijcapyuyvsnoi'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        error_log("cURL Error: " . $error_msg);
    }
    
    error_log("OneSignal API Request: " . $fields);
    error_log("OneSignal API Response - HTTP Code: " . $httpCode);
    error_log("OneSignal API Response: " . $response);
    
    curl_close($ch);

    return $response;
}
?>