<?php
header('Content-Type: application/json');

$host = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

$conn = new mysqli($host, $username, $password, $database);
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $withdraw_id = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if ($withdraw_id <= 0) {
        echo json_encode(["success" => false, "message" => "Invalid withdraw ID"]);
        exit;
    }

    // ✅ স্টেপ ১: Transaction শুরু
    $conn->begin_transaction();

    try {
        // ✅ স্টেপ ২: Withdraw details বের করা
        $stmt = $conn->prepare("SELECT user_phone, amount, status FROM withdraw WHERE id = ?");
        $stmt->bind_param("i", $withdraw_id);
        $stmt->execute();
        $stmt->bind_result($user_phone, $amount, $status);
        
        if ($stmt->fetch()) {
            $stmt->close();

            if ($status !== 'Pending') {
                echo json_encode(["success" => false, "message" => "Only Pending withdrawals can be rejected"]);
                $conn->rollback();
                exit;
            }

            // ✅ স্টেপ ৩: Withdraw status আপডেট
            $stmt = $conn->prepare("UPDATE withdraw SET status = 'Rejected' WHERE id = ?");
            $stmt->bind_param("i", $withdraw_id);
            $stmt->execute();
            $stmt->close();

            // ✅ স্টেপ ৪: ইউজারের ব্যালেন্স ফেরত
            $stmt = $conn->prepare("UPDATE users SET user_tk = user_tk + ? WHERE mobile = ?");
            $stmt->bind_param("ds", $amount, $user_phone);
            $stmt->execute();
            $stmt->close();

            // ✅ স্টেপ ৫: ইউজারকে নোটিফিকেশন পাঠানো
            $message = "আপনার {$amount} টাকার উইথড্র রিকুয়েস্টটি Reject হয়েছে। ব্যালেন্স ফেরত দেওয়া হয়েছে।";
            $notificationSent = sendOneSignalNotification($user_phone, $message, $amount, $withdraw_id);
            
            $conn->commit();
            
            if ($notificationSent) {
                echo json_encode(["success" => true, "message" => "Withdrawal rejected, balance refunded and user notified"]);
            } else {
                echo json_encode(["success" => true, "message" => "Withdrawal rejected and balance refunded but failed to notify user"]);
            }
        } else {
            $stmt->close();
            $conn->rollback();
            echo json_encode(["success" => false, "message" => "Withdraw request not found"]);
        }

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(["success" => false, "message" => "Error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}

$conn->close();

// OneSignal Notification Function
function sendOneSignalNotification($userPhone, $message, $amount, $withdraw_id) {
    $appId = "f4f3f72a-7a80-4a4d-bfc2-29ba2a4c79e9";
    
    $apiKey = "os_v2_app_6tz7okt2qbfe3p6cfg5cutdz5eh43f7upbiey6vwoywm535edrmsppzxidizy3vktnwmlf7l2dxm5hfpubhynhxj2tijcapyuyvsnoi"; 
    
    // ইউজারের ফোন নাম্বারটি external user ID হিসেবে ব্যবহার করা হচ্ছে
    $externalUserId = $userPhone;
    
    $fields = array(
        'app_id' => $appId,
        'include_external_user_ids' => array($externalUserId),
        'contents' => array(
            "en" => $message,
            "bn" => $message // বাংলা ভাষা সাপোর্ট
        ),
        'headings' => array(
            "en" => "Withdrawal Rejected",
            "bn" => "উইথড্র Reject হয়েছে"
        ),
        'data' => array(
            "type" => "withdrawal_rejected",
            "amount" => $amount,
            "withdraw_id" => $withdraw_id,
            "user_phone" => $userPhone
        ),
        'small_icon' => 'ic_stat_onesignal_default',
        'android_accent_color' => 'FFFF0000' // Red color for rejection
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $apiKey
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_error($ch)) {
        error_log("cURL Error: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);

    // Log the response for debugging
    error_log("OneSignal API Response: " . $response);

    $res = json_decode($response, true);
    
    if (isset($res['id'])) {
        error_log("OneSignal Notification Sent Successfully. ID: " . $res['id']);
        return true;
    } else {
        error_log("OneSignal Error: " . print_r($res, true));
        return false;
    }
}
?>