<?php
header('Content-Type: application/json');

$con = new mysqli("localhost", "ygfhkamb_rakib887766", "Raakib887766@#", "ygfhkamb_MatchData");

if ($con->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $con->connect_error]));
}

$match_id = $_POST['match_id'] ?? '';
$room_id = $_POST['room_id'] ?? '';
$room_pass = $_POST['room_pass'] ?? '';

if (empty($match_id) || empty($room_id) || empty($room_pass)) {
    echo json_encode("All fields are required.");
    exit;
}

// রুম ডিটেইলস আপডেট বা ইনসার্ট করা
$stmt = $con->prepare("INSERT INTO match_room_details (match_id, room_id, room_pass) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE room_id = VALUES(room_id), room_pass = VALUES(room_pass)");
$stmt->bind_param("sss", $match_id, $room_id, $room_pass);

if ($stmt->execute()) {
    // যারা ম্যাচে জয়েন করেছে তাদের ফোন নাম্বার নিয়ে আসা
    $stmt2 = $con->prepare("SELECT user_phone FROM user_match_joined WHERE match_id = ?");
    $stmt2->bind_param("s", $match_id);
    $stmt2->execute();
    $result = $stmt2->get_result();

    $externalUserIds = [];
    while ($row = $result->fetch_assoc()) {
        // ফোন নাম্বারকে External User ID হিসেবে ব্যবহার করা হবে
        $externalUserIds[] = $row['user_phone'];
    }
    $stmt2->close();

    // যদি কারো ফোন নাম্বার পাওয়া যায়, তাহলে নোটিফিকেশন পাঠানো হবে
    if (count($externalUserIds) > 0) {
        $heading = "Match Room Details";
        $message = "Room details for match $match_id have been uploaded. Join now!";
        $notify_response = sendNotificationToExternalUsers($heading, $message, $externalUserIds);
    }

    echo json_encode("Room uploaded successfully and notification sent.");
} else {
    echo json_encode("Upload failed: " . $stmt->error);
}

$stmt->close();
$con->close();


// OneSignal API দিয়ে External User IDs কে টার্গেট করে নোটিফিকেশন পাঠানোর ফাংশন
function sendNotificationToExternalUsers($heading, $message, $externalUserIds = []) {
    $content = array("en" => $message);

    $fields = array(
        'app_id' => "f4f3f72a-7a80-4a4d-bfc2-29ba2a4c79e9",  // তোমার OneSignal App ID
        'include_external_user_ids' => $externalUserIds,
        'data' => array("type" => "room_details"),
        'headings' => array("en" => $heading),
        'contents' => $content
    );

    $fields = json_encode($fields);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic os_v2_app_6tz7okt2qbfe3p6cfg5cutdz5eh43f7upbiey6vwoywm535edrmsppzxidizy3vktnwmlf7l2dxm5hfpubhynhxj2tijcapyuyvsnoi' // তোমার REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
?>
