<?php
header('Content-Type: application/json'); // JSON header

$conn = new mysqli("localhost", "ygfhkamb_rakib887766", "Raakib887766@#", "ygfhkamb_MatchData");
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => "Connection failed"]);
    exit;
}

$trx_id = $_POST['trx_id'] ?? ''; // বা deposit_id যদি Android থেকে সেটাই আসে

if (empty($trx_id)) {
    echo json_encode(['success' => false, 'message' => "Missing trx_id"]);
    exit;
}

// প্রথমে ডিপোজিট তথ্য এবং ইউজারের ফোন নাম্বার নিয়ে আসি
$sql = "SELECT d.user_phone, d.amount FROM deposits d WHERE d.trx_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $trx_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $depositData = $result->fetch_assoc();
    $user_phone = $depositData['user_phone'];
    $amount = $depositData['amount'];
    
    $stmt->close();
    
    // এখন status update করি
    $update_query = "UPDATE deposits SET status = 'Rejected' WHERE trx_id = ?";
    $stmt = $conn->prepare($update_query);
    $stmt->bind_param("s", $trx_id);
    
    if ($stmt->execute()) {
        // ইউজারকে নোটিফিকেশন পাঠাই
        $message = "আপনার {$amount} টাকার ডিপোজিট রিকুয়েস্টটি Reject হয়েছে। TRX ID: {$trx_id}";
        $notificationSent = sendOneSignalNotification($user_phone, $message, $amount, $trx_id);
        
        if ($notificationSent) {
            echo json_encode(['success' => true, 'message' => 'Deposit rejected and user notified']);
        } else {
            echo json_encode(['success' => true, 'message' => 'Deposit rejected but failed to notify user']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => "Error rejecting deposit: " . $conn->error]);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => "Deposit not found with TRX ID: " . $trx_id]);
}

$conn->close();

// OneSignal Notification Function
function sendOneSignalNotification($userPhone, $message, $amount, $trx_id) {
    // OneSignal credentials - আপনার OneSignal ক্রেডেনশিয়ালস দিন
    $appId = "f4f3f72a-7a80-4a4d-bfc2-29ba2a4c79e9"; // আপনার OneSignal App ID
    $apiKey = "os_v2_app_6tz7okt2qbfe3p6cfg5cutdz5eh43f7upbiey6vwoywm535edrmsppzxidizy3vktnwmlf7l2dxm5hfpubhynhxj2tijcapyuyvsnoi"; // আপনার OneSignal REST API Key
    
    // ইউজারের ফোন নাম্বারটি external user ID হিসেবে ব্যবহার করা হচ্ছে
    $externalUserId = $userPhone;
    
    $fields = array(
        'app_id' => $appId,
        'include_external_user_ids' => array($externalUserId),
        'contents' => array(
            "en" => $message,
            "bn" => $message // বাংলা ভাষা সাপোর্ট
        ),
        'headings' => array(
            "en" => "Deposit Rejected",
            "bn" => "ডিপোজিট Reject হয়েছে"
        ),
        'data' => array(
            "type" => "deposit_rejected",
            "amount" => $amount,
            "trx_id" => $trx_id,
            "user_phone" => $userPhone
        ),
        'small_icon' => 'ic_stat_onesignal_default',
        'android_accent_color' => 'FFFF0000' // Red color for rejection
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $apiKey
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_error($ch)) {
        error_log("cURL Error: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);

    // Log the response for debugging
    error_log("OneSignal API Response: " . $response);

    $res = json_decode($response, true);
    
    if (isset($res['id'])) {
        error_log("OneSignal Notification Sent Successfully. ID: " . $res['id']);
        return true;
    } else {
        error_log("OneSignal Error: " . print_r($res, true));
        return false;
    }
}
?>