<?php
header("Content-Type: application/json");

// ডাটাবেস কনফিগারেশন
$servername = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$dbname = "ygfhkamb_MatchData";
$charset = "utf8mb4";

$response = array();

function getDBConnection() {
    global $servername, $username, $password, $dbname, $charset;
    
    $dsn = "mysql:host=$servername;dbname=$dbname;charset=$charset";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        return new PDO($dsn, $username, $password, $options);
    } catch (PDOException $e) {
        die(json_encode([
            'status' => 'error',
            'message' => 'Database connection failed: ' . $e->getMessage()
        ]));
    }
}

// OneSignal Notification Function
function sendOneSignalNotification($externalId, $message, $data = array()) {
    $appId = "6241efcd-d64e-4847-8880-f1bc3e2c4cef"; 
    $apiKey = "os_v2_app_mja67towjzeepcea6g6d4lcm5745bepuulqu3gf2kabj3cbxobxea4glzpwcrie4opi4ob23xgghyva5pyp2ukkfpy4ymzhrt3p3kai";

    $fields = array(
        'app_id' => $appId,
        'include_external_user_ids' => array($externalId),
        'contents' => array(
            "en" => $message,
            "bn" => $message // বাংলা ভাষা সাপোর্ট
        ),
        'headings' => array(
            "en" => "New Match Join",
            "bn" => "নতুন ম্যাচ জয়েন"
        ),
        'data' => array_merge(array("type" => "match_join"), $data),
        'small_icon' => 'ic_stat_onesignal_default',
        'android_accent_color' => 'FF2196F3' // Blue color for match join
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $apiKey
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_error($ch)) {
        error_log("cURL Error: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);

    // Log the response for debugging
    error_log("OneSignal API Response: " . $response);

    $res = json_decode($response, true);
    
    if (isset($res['id'])) {
        error_log("OneSignal Notification Sent Successfully. ID: " . $res['id']);
        return true;
    } else {
        error_log("OneSignal Error: " . print_r($res, true));
        return false;
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // অত্যাবশ্যকীয় ফিল্ডগুলো
    $required_fields = array(
        'match_id', 'user_phone', 'entry_fee', 'version', 
        'match_type', 'map_type', 'win_prize', 'per_kill',
        'match_time', 'join_time', 'status', 'match_status'
    );

    $missing_fields = array();
    foreach ($required_fields as $field) {
        if (!isset($_POST[$field]) || empty($_POST[$field])) {
            $missing_fields[] = $field;
        }
    }

    if (!empty($missing_fields)) {
        $response['status'] = 'error';
        $response['message'] = 'Missing required fields: ' . implode(', ', $missing_fields);
        echo json_encode($response);
        exit;
    }

    try {
        $pdo = getDBConnection();

        // Step 1: Insert into user_match_joined
        $sql = "INSERT INTO user_match_joined (
            match_id, user_phone, entry_fee, version, 
            match_type, map_type, win_prize, per_kill,
            match_time, join_time, status, match_status, has_proof
        ) VALUES (
            :match_id, :user_phone, :entry_fee, :version, 
            :match_type, :map_type, :win_prize, :per_kill,
            :match_time, :join_time, :status, :match_status, :has_proof
        )";

        $stmt = $pdo->prepare($sql);

        $stmt->bindParam(':match_id', $_POST['match_id']);
        $stmt->bindParam(':user_phone', $_POST['user_phone']);
        $stmt->bindParam(':entry_fee', $_POST['entry_fee']);
        $stmt->bindParam(':version', $_POST['version']);
        $stmt->bindParam(':match_type', $_POST['match_type']);
        $stmt->bindParam(':map_type', $_POST['map_type']);
        $stmt->bindParam(':win_prize', $_POST['win_prize']);
        $stmt->bindParam(':per_kill', $_POST['per_kill']);
        $stmt->bindParam(':match_time', $_POST['match_time']);
        $stmt->bindParam(':join_time', $_POST['join_time']);
        $stmt->bindParam(':status', $_POST['status']);
        $stmt->bindParam(':match_status', $_POST['match_status']);
        $default_has_proof = "0";
        $stmt->bindParam(':has_proof', $default_has_proof);

        if ($stmt->execute()) {
            // Step 2: Update totalPlayed in users table
            $update = $pdo->prepare("UPDATE users SET totalPlayed = totalPlayed + 1 WHERE mobile = ?");
            $update->execute([$_POST['user_phone']]);

            // Step 3: Send notification to admin
            $adminExternalId = "01310772656"; // Admin external ID
            $message = "নতুন ম্যাচ জয়েন: ম্যাচ আইডি - {$_POST['match_id']}, টাইপ - {$_POST['match_type']}, ইউজার - {$_POST['user_phone']}";
            
            $notificationData = array(
                "match_id" => $_POST['match_id'],
                "match_type" => $_POST['match_type'],
                 "entry_fee" => $_POST['entry_fee'],
                //"user_phone" => $_POST['user_phone'],
               
            );
            
            $notificationSent = sendOneSignalNotification($adminExternalId, $message, $notificationData);

            if ($notificationSent) {
                $response['status'] = 'success';
                $response['message'] = 'Match joined successfully, totalPlayed updated & admin notified';
            } else {
                $response['status'] = 'success';
                $response['message'] = 'Match joined successfully, totalPlayed updated but failed to notify admin';
            }
        } else {
            $response['status'] = 'error';
            $response['message'] = 'Failed to insert data';
        }
    } catch (PDOException $e) {
        $response['status'] = 'error';
        $response['message'] = 'Database error: ' . $e->getMessage();
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'Invalid request method';
}

echo json_encode($response);
?>