<?php
header("Content-Type: application/json");

// Database Configuration
$host = "localhost";
$user = "ygfhkamb_rakib887766";
$pass = "Raakib887766@#";
$db = "ygfhkamb_MatchData";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

$match_id = $_GET['match_id'] ?? '';

if (empty($match_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Match ID is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT 
            uj.match_id,
            uj.user_phone,
            uj.per_kill,
            uj.win_prize,
            uj.status,
            uj.match_time,
            uj.proof,
            jp.player1 AS player_name   -- ✅ joined_players থেকে নাম নিচ্ছি
        FROM user_match_joined uj
        LEFT JOIN joined_players jp 
            ON uj.match_id = jp.match_id AND uj.user_phone = jp.user_phone
        WHERE uj.match_id = ?
    ");
    $stmt->execute([$match_id]);
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$users) {
        echo json_encode(['status' => 'error', 'message' => 'No users found for this match']);
        exit;
    }

    echo json_encode([
        'status' => 'success',
        'users' => $users
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
