<?php
header("Content-Type: application/json");

// ✅ Database credentials
$host     = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

// ✅ Create connection
$conn = new mysqli($host, $username, $password, $database);

// ✅ Check connection
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "DB connection failed: " . $conn->connect_error
    ]);
    exit();
}

// ✅ Decode incoming JSON data
$data = json_decode(file_get_contents("php://input"), true);

// ✅ Validate required fields
if (!isset($data['winners']) || !isset($data['result_type'])) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Missing data: 'winners' or 'result_type'"
    ]);
    exit();
}

$result_type = $data['result_type'];
$winners = $data['winners'];

// ✅ Prepare insert into winners table
$stmt = $conn->prepare("INSERT INTO winners (name, rank, kills, winning, match_id, is_top) VALUES (?, ?, ?, ?, ?, ?)");

if (!$stmt) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Prepare failed: " . $conn->error
    ]);
    exit();
}

$match_id_for_update = null; // will use for match_table update

// ✅ Insert each winner
foreach ($winners as $winner) {
    $name     = $winner['name'];
    $rank     = (int) $winner['rank'];
    $kills    = (int) $winner['kills'];
    $winning  = (int) $winner['winning'];
    $match_id = $winner['match_id'];
    $isTop    = (int) $winner['isTop']; // 0 or 1

    $stmt->bind_param("siiisi", $name, $rank, $kills, $winning, $match_id, $isTop);
    $stmt->execute();

    // Just grab one match_id for update (assuming all winners are for the same match)
    if ($match_id_for_update === null) {
        $match_id_for_update = $match_id;
    }
}

$stmt->close();

// ✅ Update match_table with result_type
if ($match_id_for_update !== null) {
    $stmt_update = $conn->prepare("UPDATE match_table SET match_status = ? WHERE match_id = ?");
    $stmt_update->bind_param("si", $result_type, $match_id_for_update);
    $stmt_update->execute();
    $stmt_update->close();
}

// ✅ Close connection
$conn->close();

// ✅ Response
echo json_encode([
    "status" => "success",
    "message" => "Winners inserted and match status updated successfully."
]);
?>
