<?php
header("Content-Type: application/json");

// Database Configuration
$host = "localhost";
$user = "ygfhkamb_rakib887766";
$pass = "Raakib887766@#";
$db = "ygfhkamb_MatchData";

// Database connection
try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// ✅ Read raw JSON body
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

// ✅ Extract values from JSON (and sanitize)
$user_phone = isset($data['user_phone']) ? trim($data['user_phone']) : '';
$match_id   = isset($data['match_id'])   ? trim($data['match_id'])   : '';
$status     = isset($data['status'])     ? trim($data['status'])     : '';
$win_prize  = isset($data['win_prize'])  ? trim($data['win_prize'])  : '0'; // Default 0 if empty

// ✅ Debug log (for development only — remove in production)
file_put_contents("debug_update_log.txt", date("Y-m-d H:i:s") . " - " . json_encode($data) . PHP_EOL, FILE_APPEND);

// ✅ Validate inputs
if (empty($user_phone) || empty($match_id) || empty($status)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Required fields missing',
        'user_phone' => $user_phone,
        'match_id' => $match_id,
        'status' => $status
    ]);
    exit;
}

// ✅ Try updating the database
try {
    $pdo->beginTransaction();

    // Step 1: Update user_match_joined table
    $stmt = $pdo->prepare("
        UPDATE user_match_joined 
        SET status = ?, win_prize = ?
        WHERE match_id = ? AND user_phone = ?
    ");
    $stmt->execute([$status, $win_prize, $match_id, $user_phone]);

    if ($stmt->rowCount() == 0) {
        $pdo->rollBack();
        echo json_encode([
            'status' => 'error',
            'message' => 'No such user_match_joined record found for this match/user'
        ]);
        exit;
    }

    // Step 2: If status is 'won', then update users table by adding win_prize
    if ($status === 'won') {
        // Get current user balance and totalWon
        $stmtSelect = $pdo->prepare("SELECT user_tk, totalWon FROM users WHERE mobile = ?");
        $stmtSelect->execute([$user_phone]);
        $row = $stmtSelect->fetch();

        if (!$row) {
            $pdo->rollBack();
            echo json_encode([
                'status' => 'error',
                'message' => 'No such user found in users table'
            ]);
            exit;
        }

        // Calculate new balance and new totalWon
        $currentBalance = floatval($row['user_tk']);
        $currentTotalWon = floatval($row['totalWon']);
        $prizeAmount = floatval($win_prize);

        $newBalance = $currentBalance + $prizeAmount;
        $newTotalWon = $currentTotalWon + $prizeAmount;

        // Update new balance and totalWon
        $stmt2 = $pdo->prepare("
            UPDATE users 
            SET user_tk = ?, totalWon = ?
            WHERE mobile = ?
        ");
        $stmt2->execute([$newBalance, $newTotalWon, $user_phone]);

        if ($stmt2->rowCount() == 0) {
            $pdo->rollBack();
            echo json_encode([
                'status' => 'error',
                'message' => 'User balance update failed'
            ]);
            exit;
        }
    }

    // ✅ Everything is successful
    $pdo->commit();
    echo json_encode(['status' => 'success']);
} catch (PDOException $e) {
    $pdo->rollBack();
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
