<?php
header("Content-Type: application/json");

// ডাটাবেস কানেকশন
$servername = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$dbname = "ygfhkamb_MatchData";

$conn = new mysqli($servername, $username, $password, $dbname);

// কানেকশন চেক
if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

$match_id = isset($_POST['match_id']) ? trim($_POST['match_id']) : "";

if (empty($match_id)) {
    echo json_encode(["status" => "error", "message" => "No match_id received"]);
    exit;
}

// Debug: লগ ফাইলে লিখে দেখি আসলে কী match_id পাঠানো হচ্ছে
file_put_contents("debug_log.txt", "Received match_id: $match_id\n", FILE_APPEND);

try {
    // 1. joined_players টেবিল থেকে কতজন জয়েন করেছে
    $stmt = $conn->prepare("SELECT COUNT(*) as joined FROM joined_players WHERE match_id = ?");
    $stmt->bind_param("s", $match_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $joinedRow = $result->fetch_assoc();
    $joined = $joinedRow ? (int)$joinedRow['joined'] : 0;
    $stmt->close();

    // 2. match_table থেকে needUser পাওয়া যাচ্ছে কিনা
    $stmt = $conn->prepare("SELECT need_user FROM match_table WHERE match_id = ?");
    $stmt->bind_param("s", $match_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $match = $result->fetch_assoc();
    $stmt->close();

    if ($match) {
        echo json_encode([
            "status" => "success",
            "joined" => $joined,
            "need_users" => (int)$match['need_user']
        ]);
    } else {
        // যদি না মিলে, সব match_id বের করে ফাইল এ রাখো চেক করার জন্য
        $all = $conn->query("SELECT match_id FROM match_table");
        $allIds = "";
        while ($row = $all->fetch_assoc()) {
            $allIds .= $row['match_id'] . "\n";
        }
        file_put_contents("match_ids_dump.txt", $allIds);
        echo json_encode(["status" => "error", "message" => "Match not found"]);
    }

} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
} finally {
    $conn->close();
}
?>
