<?php
header('Content-Type: application/json');

// Allow only POST requests
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo json_encode(["success" => false, "message" => "Only POST requests allowed"]);
    exit();
}

// DB Config
$host = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

// DB Connection
$conn = new mysqli($host, $username, $password, $database);

// DB connection failed
if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Database connection failed"]));
}

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

// Check for valid JSON input
if (!$data) {
    echo json_encode(["success" => false, "message" => "No JSON data received"]);
    exit();
}

// Extract input
$first_name = $data["first_name"] ?? "";
$last_name = $data["last_name"] ?? "";
$username = $data["username"] ?? "";
$email = $data["email"] ?? "";
$mobile = $data["mobile"] ?? "";
$password = $data["password"] ?? "";
$fcm_token = $data["fcm_token"] ?? ""; // নতুন FCM token ফিল্ড

// Check if email or mobile already exists
$check = $conn->prepare("SELECT id FROM users WHERE email = ? OR mobile = ?");
$check->bind_param("ss", $email, $mobile);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo json_encode(["success" => false, "message" => "Email or Mobile already exists"]);
    $check->close();
    $conn->close();
    exit();
}
$check->close();

// Insert user
$stmt = $conn->prepare("INSERT INTO users (first_name, last_name, username, email, mobile, password, fcm_token) VALUES (?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("sssssss", $first_name, $last_name, $username, $email, $mobile, $password, $fcm_token);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Registration successful"]);
} else {
    echo json_encode(["success" => false, "message" => "Registration failed"]);
}

$stmt->close();
$conn->close();
?>
