<?php
header('Content-Type: application/json');

$host = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Total Users (treating all as VARCHAR)
    $stmt = $pdo->query("SELECT COUNT(*) AS total_users FROM users");
    $totalUsers = (int)$stmt->fetch(PDO::FETCH_ASSOC)['total_users'];

    // Blocked Users (treating is_blocked as VARCHAR)
    $stmt = $pdo->query("SELECT COUNT(*) AS blocked_users FROM users WHERE is_blocked = '1' OR is_blocked = 'yes'");
    $blockedUsers = (int)$stmt->fetch(PDO::FETCH_ASSOC)['blocked_users'];

    // Total Deposit (amount stored as VARCHAR)
    $stmt = $pdo->query("SELECT SUM(CAST(amount AS DECIMAL(10,2))) AS total_deposit FROM deposits");
    $totalDeposit = (float)$stmt->fetch(PDO::FETCH_ASSOC)['total_deposit'];
    $totalDeposit = $totalDeposit ? $totalDeposit : 0;

    // Total Withdraw (amount stored as VARCHAR)
    $stmt = $pdo->query("SELECT SUM(CAST(amount AS DECIMAL(10,2))) AS total_withdraw FROM withdraw");
    $totalWithdraw = (float)$stmt->fetch(PDO::FETCH_ASSOC)['total_withdraw'];
    $totalWithdraw = $totalWithdraw ? $totalWithdraw : 0;

    // Response
    $response = [
        "status" => "success",
        "data" => [
            "total_users" => $totalUsers,
            "blocked_users" => $blockedUsers,
            "total_deposit" => $totalDeposit,
            "total_withdraw" => $totalWithdraw
        ]
    ];

    echo json_encode($response, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database Error: " . $e->getMessage()
    ]);
}
?>