<?php
// Allow from any origin (CORS)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['match_category'])) {
        $match_category = $_POST['match_category'];
        $message = "$match_category Match Added!";

        // image_url প্যারামিটার ডিফল্ট ভ্যালু দিতে পারো
        $image_url = isset($_POST['image_url']) ? $_POST['image_url'] : "";

        $response = sendNotificationToAll("New Match Alert", $message, $image_url);
        echo json_encode([
            'success' => true,
            'message' => 'Notification sent successfully',
            'onesignal_response' => json_decode($response)
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'match_category parameter missing'
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Invalid request method'
    ]);
}


function sendNotificationToAll($heading, $message, $image_url = "") {
    $content = array("en" => $message);

    $fields = array(
        'app_id' => "f4f3f72a-7a80-4a4d-bfc2-29ba2a4c79e9", // তোমার OneSignal App ID
        'included_segments' => array('All'),
        'data' => array("type" => "match"),
        'headings' => array("en" => $heading),
        'contents' => $content,
    );

    // যদি image_url থাকে, তাহলে সেটি অ্যাড করো
    if (!empty($image_url)) {
        $fields['big_picture'] = $image_url;   // OneSignal-এ বড় ছবি
        $fields['ios_attachments'] = array("id" => $image_url); // iOS এর জন্য
        $fields['android_accent_color'] = "FF0000FF"; // ঐচ্ছিক: নোটিফিকেশনের রঙ
    }

    $fields = json_encode($fields);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic os_v2_app_6tz7okt2qbfe3p6cfg5cutdz5eh43f7upbiey6vwoywm535edrmsppzxidizy3vktnwmlf7l2dxm5hfpubhynhxj2tijcapyuyvsnoi' // তোমার REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
?>
