<?php
header('Content-Type: application/json');

// Database connection info
$host = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

$conn = new mysqli($host, $username, $password, $database);
if ($conn->connect_error) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]);
    exit;
}

$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // ইনপুট নেওয়া
    $user_phone = isset($_POST['user_phone']) ? trim($_POST['user_phone']) : '';
    $amount = isset($_POST['amount']) ? trim($_POST['amount']) : '';
    $method = isset($_POST['method']) ? trim($_POST['method']) : '';
    $withdraw_number = isset($_POST['withdraw_number']) ? trim($_POST['withdraw_number']) : '';
    $date_time = isset($_POST['date_time']) ? trim($_POST['date_time']) : '';
    $status = isset($_POST['status']) ? trim($_POST['status']) : 'Pending';  // ডিফল্ট Pending

    // ভ্যালিডেশন
    if (empty($user_phone) || empty($amount) || empty($method) || empty($withdraw_number) || empty($date_time)) {
        echo json_encode(["success" => false, "message" => "সবগুলো ঘর পূরণ করুন"]);
        exit;
    }

    if (!is_numeric($amount) || $amount <= 0) {
        echo json_encode(["success" => false, "message" => "টাকার পরিমাণ সঠিক নয়"]);
        exit;
    }
    $amount_value = floatval($amount);

    // ইউজারের বর্তমান ব্যালেন্স চেক
    $stmt = $conn->prepare("SELECT user_tk FROM users WHERE mobile = ?");
    $stmt->bind_param("s", $user_phone);
    $stmt->execute();
    $stmt->bind_result($user_tk);

    if ($stmt->fetch()) {
        $current_balance = floatval($user_tk);
        $stmt->close();

        if ($current_balance < $amount_value) {
            echo json_encode(["success" => false, "message" => "You do not have sufficient balance in your account."]);
            exit;
        }
    } else {
        $stmt->close();
        echo json_encode(["success" => false, "message" => "ইউজার পাওয়া যায়নি"]);
        exit;
    }

    // Transaction শুরু করা
    $conn->begin_transaction();

    try {
        // Withdraw টেবিলে ইনসার্ট
        $insert_stmt = $conn->prepare("INSERT INTO withdraw (user_phone, amount, method, withdraw_number, date_time, status) VALUES (?, ?, ?, ?, ?, ?)");
        $insert_stmt->bind_param("sdssss", $user_phone, $amount_value, $method, $withdraw_number, $date_time, $status);
        $insert_stmt->execute();
        $insert_stmt->close();

        // ব্যালেন্স আপডেট
        $new_balance = $current_balance - $amount_value;
        $update_stmt = $conn->prepare("UPDATE users SET user_tk = ? WHERE mobile = ?");
        $update_stmt->bind_param("ds", $new_balance, $user_phone);
        $update_stmt->execute();
        $update_stmt->close();

        // Transaction commit
        $conn->commit();

        // এডমিনকে নোটিফিকেশন পাঠানো
        $adminExternalId = "01310772656"; // Admin external ID in OneSignal
        $message = "নতুন উইথড্র রিকুয়েস্ট: {$amount} টাকা, ফোন: {$user_phone}, মাধ্যম: {$method}";
        
        $notificationSent = sendOneSignalNotification($adminExternalId, $message);

        if ($notificationSent) {
            echo json_encode(["success" => true, "message" => "Your withdrawal was successful. Admin notified."]);
        } else {
            echo json_encode(["success" => true, "message" => "Your withdrawal was successful. But failed to notify admin."]);
        }

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(["success" => false, "message" => "Withdraw failed: " . $e->getMessage()]);
    }

} else {
    echo json_encode(["success" => false, "message" => "অবৈধ রিকোয়েস্ট মেথড"]);
}

$conn->close();

// OneSignal Notification Function
function sendOneSignalNotification($externalId, $message) {
   $appId = "6241efcd-d64e-4847-8880-f1bc3e2c4cef";
    
    $apiKey = "os_v2_app_mja67towjzeepcea6g6d4lcm5745bepuulqu3gf2kabj3cbxobxea4glzpwcrie4opi4ob23xgghyva5pyp2ukkfpy4ymzhrt3p3kai";
    
    $fields = array(
        'app_id' => $appId,
        'include_external_user_ids' => array($externalId),
        'contents' => array(
            "en" => $message,
            "bn" => $message // Bengali language support
        ),
        'headings' => array(
            "en" => "New Withdrawal Request",
            "bn" => "নতুন উইথড্র রিকুয়েস্ট"
        ),
        'data' => array(
            "type" => "withdrawal_request",
            "user_phone" => $_POST['user_phone'] ?? '',
            "amount" => $_POST['amount'] ?? '',
            "method" => $_POST['method'] ?? ''
        ),
        'small_icon' => 'ic_stat_onesignal_default',
        'android_accent_color' => 'FFFF0000' // Red color for withdrawal notifications
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $apiKey
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_error($ch)) {
        error_log("cURL Error: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);

    // Log the full response for debugging
    error_log("OneSignal API Response: " . $response);
    error_log("OneSignal HTTP Code: " . $httpCode);

    $res = json_decode($response, true);
    
    if (isset($res['id'])) {
        error_log("OneSignal Notification Sent Successfully. ID: " . $res['id']);
        return true;
    } else {
        error_log("OneSignal Error: " . print_r($res, true));
        return false;
    }
}
?>