<?php
$host = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

$conn = new mysqli($host, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed");
}

$id = $_POST['id'] ?? '';
$status = $_POST['status'] ?? '';

if ($id != '' && $status != '') {
    // প্রথমে withdraw তথ্য এবং ইউজারের ফোন নাম্বার নিয়ে আসি
    $sql = "SELECT w.user_phone, w.amount FROM withdraw w WHERE w.id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $withdrawData = $result->fetch_assoc();
        $user_phone = $withdrawData['user_phone'];
        $amount = $withdrawData['amount'];
        
        $stmt->close();
        
        // এখন status update করি
        $sql = "UPDATE withdraw SET status=? WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $status, $id);
        
        if ($stmt->execute()) {
            // যদি status approved হয়, তাহলে ইউজারকে নোটিফিকেশন পাঠাই
            if ($status === 'Approved') {
                $message = "আপনার {$amount} টাকার উইথড্র রিকুয়েস্টটি Approved হয়েছে।";
                $notificationSent = sendOneSignalNotification($user_phone, $message, $amount);
                
                if ($notificationSent) {
                    echo "success_notified";
                } else {
                    echo "success_but_notification_failed";
                }
            } else {
                echo "success";
            }
        } else {
            echo "error";
        }
        $stmt->close();
    } else {
        echo "withdraw_not_found";
    }
} else {
    echo "invalid";
}

$conn->close();

// OneSignal Notification Function
function sendOneSignalNotification($userPhone, $message, $amount) {
    // ✅ OneSignal credentials - সঠিক credentials দিয়ে replace করুন
    $appId = "f4f3f72a-7a80-4a4d-bfc2-29ba2a4c79e9"; // আপনার OneSignal App ID
    $apiKey = "os_v2_app_6tz7okt2qbfe3p6cfg5cutdz5eh43f7upbiey6vwoywm535edrmsppzxidizy3vktnwmlf7l2dxm5hfpubhynhxj2tijcapyuyvsnoi"; // আপনার OneSignal REST API Key
    
    // Debug info
    error_log("Sending notification to: " . $userPhone);
    error_log("Message: " . $message);
    
    // ইউজারের ফোন নাম্বারটি external user ID হিসেবে ব্যবহার করা হচ্ছে
    $externalUserId = $userPhone;
    
    $fields = array(
        'app_id' => $appId,
        'include_external_user_ids' => array($externalUserId),
        'contents' => array(
            "en" => $message,
            "bn" => $message // বাংলা ভাষা সাপোর্ট
        ),
        'headings' => array(
            "en" => "Withdrawal Approved",
            "bn" => "উইথড্র Approved হয়েছে"
        ),
        'data' => array(
            "type" => "withdrawal_approved",
            "amount" => $amount,
            "user_phone" => $userPhone
        ),
        'small_icon' => 'ic_stat_onesignal_default',
        'android_accent_color' => 'FF267F00' // Green color for approval
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $apiKey
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_VERBOSE, true); // verbose mode for debugging

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_error($ch)) {
        $errorMsg = "cURL Error: " . curl_error($ch);
        error_log($errorMsg);
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);

    // Log the full response for debugging
    error_log("OneSignal API Response: " . $response);
    error_log("OneSignal HTTP Code: " . $httpCode);

    $res = json_decode($response, true);
    
    if (isset($res['id'])) {
        error_log("OneSignal Notification Sent Successfully. ID: " . $res['id']);
        return true;
    } else {
        error_log("OneSignal Error: " . print_r($res, true));
        
        // Check specific error cases
        if (isset($res['errors'])) {
            foreach ($res['errors'] as $error) {
                error_log("OneSignal Error Detail: " . $error);
            }
        }
        
        return false;
    }
}
?>