<?php
header('Content-Type: application/json');

$host = "localhost";
$username = "ygfhkamb_rakib887766";
$password = "Raakib887766@#";
$database = "ygfhkamb_MatchData";

try {
    // ১. Database connection
    $pdo = new PDO("mysql:host=$host;dbname=$database;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // ২. POST data receive
    $user_phone    = $_POST['user_phone'] ?? '';
    $amount        = $_POST['amount'] ?? '';
    $trx_id        = $_POST['trx_id'] ?? '';
    $sender_number = $_POST['sender_number'] ?? '';
    $method        = $_POST['method'] ?? '';
    $date_time     = $_POST['date_time'] ?? '';
    $status        = "Pending"; // Default status

    // ৩. Validation
    if (empty($user_phone) || empty($amount) || empty($trx_id) || empty($sender_number) || empty($method) || empty($date_time)) {
        echo json_encode(['success' => false, 'message' => 'All fields are required.']);
        exit;
    }

    // ৪. Check duplicate trx_id
    $stmt = $pdo->prepare("SELECT * FROM deposits WHERE trx_id = ?");
    $stmt->execute([$trx_id]);
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => false, 'message' => 'This transaction ID has already been used.']);
        exit;
    }

    // ৫. Insert into database
    $stmt = $pdo->prepare("INSERT INTO deposits (user_phone, amount, trx_id, sender_number, method, deposit_date, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$user_phone, $amount, $trx_id, $sender_number, $method, $date_time, $status]);

    // ৬. Send notification to Admin
    $adminExternalId = "01310772656"; // Admin external ID in OneSignal
    $message = "নতুন ডিপোজিট রিকুয়েস্ট: {$amount} টাকা, ফোন: {$user_phone}, TRX: {$trx_id}";
    
    $notificationSent = sendOneSignalNotification($adminExternalId, $message);

    if ($notificationSent) {
        echo json_encode(['success' => true, 'message' => 'Deposit request submitted successfully. Admin notified.']);
    } else {
        echo json_encode(['success' => true, 'message' => 'Deposit request submitted successfully. But failed to notify admin.']);
    }

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}

// ৭. OneSignal Notification Function
function sendOneSignalNotification($externalId, $message) {
    // OneSignal credentials - REPLACE THESE WITH YOUR ACTUAL CREDENTIALS
    $appId = "6241efcd-d64e-4847-8880-f1bc3e2c4cef"; // এখানে তোমার OneSignal App ID বসাও
    $apiKey = "os_v2_app_mja67towjzeepcea6g6d4lcm5745bepuulqu3gf2kabj3cbxobxea4glzpwcrie4opi4ob23xgghyva5pyp2ukkfpy4ymzhrt3p3kai"; // এখানে তোমার REST API Key বসাও
    
    // Debugging: Log the credentials (remove in production)
    error_log("OneSignal App ID: " . $appId);
    error_log("OneSignal API Key: " . $apiKey);

    $fields = array(
        'app_id' => $appId,
        'include_external_user_ids' => array($externalId),
        'contents' => array(
            "en" => $message,
            "bn" => $message // Bengali language support
        ),
        'headings' => array(
            "en" => "New Deposit Request",
            "bn" => "নতুন ডিপোজিট রিকুয়েস্ট"
        ),
        'data' => array(
            "type" => "deposit_request",
            "user_phone" => $_POST['user_phone'] ?? '',
            "amount" => $_POST['amount'] ?? '',
            "trx_id" => $_POST['trx_id'] ?? ''
        ),
        'small_icon' => 'ic_stat_onesignal_default', // Make sure this icon exists in your app
        'android_accent_color' => 'FF267F00' // Green color for Android
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $apiKey
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // 10 second timeout

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_error($ch)) {
        error_log("cURL Error: " . curl_error($ch));
    }
    
    curl_close($ch);

    // Log the full response for debugging
    error_log("OneSignal API Response: " . $response);
    error_log("OneSignal HTTP Code: " . $httpCode);

    $res = json_decode($response, true);
    
    if (isset($res['id'])) {
        error_log("OneSignal Notification Sent Successfully. ID: " . $res['id']);
        return true;
    } else {
        error_log("OneSignal Error: " . print_r($res, true));
        return false;
    }
}
?>